import java.util.*;

public class Figura {
    Vector3D translacion = new Vector3D();
    Vector3D rotacion = new Vector3D();
    Vector3D coordenadasMundo = new Vector3D();
    Vector caras = new Vector();
    int numCaras = 0;

    public Figura(){
        //Salida.salida("Figura: constructor por defecto");
    }

    public Figura( Vector caras){
//        Salida.salida("Figura: constructor general (" + caras.size() + " caras)");
        this.caras = caras;
    }

    public Figura( Figura figura ){
        this.translacion = new Vector3D( figura.translacion );
        this.rotacion = new Vector3D( figura.rotacion );
        this.coordenadasMundo = new Vector3D( figura.coordenadasMundo );
        this.caras = (Vector) figura.caras.clone();
        this.numCaras = figura.numCaras;
    }


    public void addCara(Cara cara){
//        Salida.salida("Figura: addCara (" + cara.numVertices + "vertices)");
        numCaras++;
        this.caras.addElement(cara);
    }

    public void removeCara(int cara){
        numCaras--;
        this.caras.removeElementAt(cara);
    }

   public void transladar(Vector3D translacion){
        this.translacion.x += translacion.x;
        this.translacion.y += translacion.y;
        this.translacion.z += translacion.z;
    }

    public void rotar( Vector3D rotacion){
        this.rotacion.x += rotacion.x;
        this.rotacion.y += rotacion.y;
        this.rotacion.z += rotacion.z;
    }

    public Vector3D getCoordenadasMundo(){ return this.coordenadasMundo; }
    public void setCoordenadasMundo(Vector3D coordenadasMundo){ this.coordenadasMundo = coordenadasMundo; }

    public Vector3D getTranslacion(){ return this.translacion; }
    public void setTransalacion(Vector3D translacion){ this.translacion = translacion; }

    public Vector3D getRotacion(){ return this.rotacion; }
    public void setRotacion(Vector3D rotacion){ this.rotacion = rotacion; }





}
